program bin2hex;
{$APPTYPE CONSOLE}
uses
  SysUtils;

var checksum,B,f,n:byte;
           address:cardinal;
            source:file of byte;
            target:text;

begin
  assign(target,'intel.hex');
  try
    rewrite(target)
  except
    writeln('error opening intel.hex');
    halt
  end;

  for f:=1 to 2 do
  begin

    case f of 1:try
                  assign(source,'prog.bin');
                  reset(source);
                  address:=$1D000000;
                  writeln(#13, 'processing prog.bin')
                except
                  writeln(#13, 'error opening prog.bin');
                  halt
                end;
              2:try
                  assign(source,'boot.bin');
                  reset(source);
                  address:=$1FC00000;
                  writeln(#13, 'processing boot.bin')
                except
                  writeln(#13, 'error opening boot.bin');
                  halt
                end
    end;  { of case }


    repeat
      if (address and $FFFF)=0 then            // write "Extended Linear Address" record
      begin
        checksum:=$02 + $0000 + $04 + hi(address shr 16) + lo(address shr 16);
        writeln(target, ':02000004' + inttohex(address shr 16, 4) + inttohex(lo(-checksum), 2))
      end;

      if (address and $FF)=0 then write(#13, inttohex(address, 8));

      checksum:=$10 +hi(address) + lo(address) + $00;
      write(target, ':10' + inttohex(address and $FFFF, 4) + '00');

      
      for n:=1 to 16 do                        // write "Data" record
      begin
        if not(eof(source)) then read(source, B)
                            else B:=$FF;
        inc(checksum, B);
        write(target, inttohex(B, 2));
        inc(address)
      end;

      writeln(target, inttohex(lo(-checksum), 2))
    until eof(source);

    close(source)

  end;

  writeln(target, ':00000001FF');              // write "End Of File" record
  close(target);
  writeln(#13, 'finished')
end.